﻿QIPortalAPI.filters = new Object();
//$.getScript('Modules/QIPortal/scripts/i18n/jquery.multiselect.cs2.js');

(function()
{
	var f = QIPortalAPI.filters;
	f.items = [];
	f.otherItems = [];
	f.attributes = [];
	f.activeFilters = [];
	f.focusedId = null;
	f.activeTab = null;

	var filterDef = {
		type: 0, 				// 0 = global attr, 1 = local attr, 2 = parameter
		id: '13689851_10', 	// id filtru
		caption: '', 		// label
		selectionType: 0, 	// 0 = one value, 1 = multiple values, 2 = range, 3 = existence
		items: [
			{
				group: '', 	// skupina pro typ parametr
				value: '', 	// hodnota 
				text: '', 	// text pro zobrazení
				selected: true  // vybraný
			}
		]
	};

	if (window.location.search)
	{
		var srch = window.location.search.substring(1);
		var srchItems = srch.split('&');
		for (var i = 0; i < srchItems.length; i++)
		{
			var sParam = srchItems[i].split('=');
			var sName = sParam[0];
			if (sParam[0].substr(0, 4) == 'flt_')
			{
				var item = f.items[sName];
				if (item == null)
					f.items[sName] = [decodeURIComponent(sParam[1])];
				else
					f.items[sName].push(decodeURIComponent(sParam[1]));
			}
			else
			{
				if (sName == 'focus')
				{
					f.focusedId = sParam[1];
				}
				else
				if (sName == 'fTab')
				{
					f.activeTab = sParam[1];
				}
				else
				if ((sName != 'scroll') && (sName != 'fSet'))
					f.otherItems.push(srchItems[i]);
			}
		}
	}
	
	var reload = function(def)
	{
		if ((QIPortalAPI.filters.helpDeskTicketGrid) && (f.helpDeskSequence) && (def))
		{
			var idx = f.definitions.indexOf(def);
			if (idx > -1)
			{
				for (var i = idx + 1; i < f.definitions.length; i++)
				{
					var def2 = f.definitions[i];

					$.each(def2.items, function(j, item) {
						item.selected = false;
						var control = $('#' + def2.itemsPrefix + def2.id + '_' + j)[0];
						if (!control)
							control = $('#' + def2.itemsPrefix + def2.id)[0];

						if (def2.selectionType == 2)
						{
							def2.items[0].value = def2.items[0].text = def2.minValue;
							def2.items[1].value = def2.items[1].text = def2.maxValue;

							$('#sldr_flt_' + def2.id).slider("values", [def2.minValueSlider, def2.maxValueSlider]);
						}
						else
							if (control)
							{
								if ((control.type == 'checkbox') || (control.type == 'radio'))
								{
									$(control).attr('checked', false);
								}
								else
									if (control.options)
									{
										$.each(control.options, function(i, option) {
											option.selected = false;
										});
									}
							}
					});
					delete f.items['flt_' + def2.id];
				}
				;
			}
		}

		var newLocation = window.location.href;

		var idx = newLocation.indexOf('#');
		var add = '';
		if (idx > -1)
		{
			add = newLocation.substr(idx);
			newLocation = newLocation.substr(0, idx);
		}

		idx = newLocation.indexOf('?');
		if (idx > -1)
			newLocation = newLocation.substr(0, idx);

		var qs = [];
		var qsFlt = [];

		qs.push('fSet=1');

		if (f.otherItems.length > 0)
		{
			qs.push(f.otherItems.join('&'));
		}

		for (var key in f.items)
		{
			var items = f.items[key];
			if (typeof(items) == 'function')
				continue;

			if ($.isArray(items))
			{
				$.each(items, function(_, item) {
					if (item)
						item = item.htmlDecode();
					qs.push(key + '=' + encodeURIComponent(item));
					qsFlt.push(key + '=' + item);
				});
			}
			else
			{
				qs.push(key + '=' + encodeURIComponent(items));
				qsFlt.push(key + '=' + items);
			}
		}

		if (QIPortalAPI.getScrollPosition() > 0)
			qs.push('scroll=' + QIPortalAPI.getScrollPosition());

		if (f.activeTab)
			qs.push('fTab=' + f.activeTab);

		if (qs.length > 0)
			newLocation += '?' + qs.join('&');

		if (QIPortalAPI.filters.helpDeskTicketGrid)
		{
			f.activeFilters = [];
			for (var key in f.items)
			{
				var def2 = findDef(key);
				if (def2 != null)
				{
					var item = f.items[key];
					for (var j = 0; j < def2.items.length; j++)
					{
						def2.items[j].selected = false;
						if (def2.selectionType == 2)
						{
							/*
							if (def2.isDateTime)
							{
							if (item[0] == def2.items[0].value + '|' + def2.items[1].value)
							addActiveFilter(def2);
							}
							*/
							addActiveFilter(def2);
						}
						else
						{
							for (var i = 0; i < item.length; i++)
							{
								if (item[i] == def2.items[j].value)
								{
									addActiveFilter(def2);
									def2.items[j].selected = true;
								}
							}
						}
					}
				}
			}

			setInfo(f.filterInfoControlId, f.filterInfoOptions);
			f.helpDeskTicketGridParams = qsFlt;
			QIHelpDesk.grid.refreshTicketGrid(qsFlt);

			if (History)
				History.replaceState({}, document.title, newLocation + add);
		}
		else
		{
			window.location.href = newLocation + add;
		}
	};

	f.change = function(id, control, value)
	{
		var values = [], doSet = false;

		if (control.selectedOptions)
		{
			$.each(control.selectedOptions, function(_, opt) {
				var val = opt.value;
				if (val != '*')
					values.push(val);
			});

			doSet = true;
		}
		else
			if (typeof control.checked != 'undefined')
			{

				values = f.items[id];
				if (!values)
				{
					if (control.checked)
						f.items[id] = [value];
				}
				else
				{
					var idx = -1;
					for (var i = 0; i < values.length; i++)
					{
						if (values[i] == value)
						{
							idx = i;
							break;
						}
					}
					;

					if (control.checked)
					{
						if (idx == -1)
							values.push(value);
					}
					else
					{
						if (idx > -1)
							values.splice(idx, 1);
					}

					doSet = true;
				}
			}
			else
			{
				var vals = $(control).val();
				if (vals)
				{
					if ($.isArray(vals))
					{
						for (var i = 0; i < vals.length; i++)
						{
							var val = vals[i];
							if (val != '*')
								values.push(val);
						}
					}
					else
					{
						if (vals != '*')
							values = [vals];
					}
				}
				doSet = true;
			}

		if (doSet)
		{
			if (values.length == 0)
				delete f.items[id];
			else
				f.items[id] = values;

			reload(findDef(id));
		}
	};

	function addActiveFilter(def)
	{
		//if (f.activeFilters.indexOf(def) > -1)
		if (jQuery.inArray(def, f.activeFilters) > -1)
			return;

		f.activeFilters.push(def);
	}

	var initTimeoutSet = false;
	f.init = function(controlId, options)
	{
		switch (options.renderType.toLowerCase())
		{
		case '':
		case 'basic':
			{
				renderDefault(controlId, options);
				break;
			}
		case 'sections':
			{
				renderSections(controlId, options);
				break;
			}
		case 'tabs':
			{
				renderTabs(controlId, options);
				break;
			}
		default:
			alert('Unknown filter render type: ' + options.renderType);
		}

		if (!initTimeoutSet)
		{
			initTimeoutSet = true;

			window.setTimeout(function() {
				for (var i = 0; i < f.definitions.length; i++)
				{
					var def = f.definitions[i];
					if (def.selectionType == 2)	// slider
					{
						if ($('#sldr_flt_' + def.id).length)
						{
							var hasItems = (def.items) && (def.items.length > 0);
							var start = ((hasItems) && (def.items[0].value == '*')) ? 1 : 0;

							if (def.isDateTime)
							{

								(function()
								{
									var lDef = def;
									var parts = lDef.minValue.split('.');
									var minDate = new Date(parseInt(parts[2], 10), parseInt(parts[1], 10) - 1, parseInt(parts[0]));
									parts = lDef.maxValue.split('.');
									var maxDate = new Date(parseInt(parts[2], 10), parseInt(parts[1], 10) - 1, parseInt(parts[0]), 23, 59, 59);

									var valuesMin, valuesMax;
									if (lDef.items[start].value === '')
									{
										valuesMin = minDate;
									}
									else
									{
										parts = lDef.items[start].value.split('.');
										valuesMin = new Date(parseInt(parts[2], 10), parseInt(parts[1], 10) - 1, parseInt(parts[0]));
									}
									var d1 = valuesMin.getDate() + '.' + (valuesMin.getMonth() + 1) + '.' + valuesMin.getFullYear();

									if (lDef.items[lDef.items.length - 1].value === '')
									{
										valuesMax = maxDate;
									}
									else
									{
										parts = lDef.items[lDef.items.length - 1].value.split('.');
										valuesMax = new Date(parseInt(parts[2], 10), parseInt(parts[1], 10) - 1, parseInt(parts[0]));
									}
									var d2 = valuesMax.getDate() + '.' + (valuesMax.getMonth() + 1) + '.' + valuesMax.getFullYear();

									lDef.minValueSlider = (valuesMin.getTime() / 1000);
									lDef.maxValueSlider = (valuesMax.getTime() / 1000);

									$('#sldr_flt_' + lDef.id + '_info').html('<strong>' + d1 + '</strong> - <strong>' + d2 + '</strong>');

									$('#sldr_flt_' + lDef.id).slider(
										{
											range: true,
											min: (minDate.getTime() / 1000),
											max: (maxDate.getTime() / 1000),
											step: 86400,
											values: [lDef.minValueSlider, lDef.maxValueSlider],
											change: function(event, ui)
											{
												var date = new Date(ui.values[0] * 1000);
												d1 = date.getDate() + '.' + (date.getMonth() + 1) + '.' + date.getFullYear();

												date = new Date(ui.values[1] * 1000);
												d2 = date.getDate() + '.' + (date.getMonth() + 1) + '.' + date.getFullYear();

												$('#sldr_flt_' + lDef.id + '_info').html('<strong>' + d1 + '</strong> - <strong>' + d2 + '</strong>');
											},
											slide: function(event, ui)
											{
												var date = new Date(ui.values[0] * 1000);
												d1 = date.getDate() + '.' + (date.getMonth() + 1) + '.' + date.getFullYear();

												date = new Date(ui.values[1] * 1000);
												d2 = date.getDate() + '.' + (date.getMonth() + 1) + '.' + date.getFullYear();

												$('#sldr_flt_' + lDef.id + '_info').html('<strong>' + d1 + '</strong> - <strong>' + d2 + '</strong>');
											},
											stop: function(event, ui)
											{
												var newMinDate = new Date(ui.values[0] * 1000);
												var newMaxDate = new Date(ui.values[1] * 1000);

												//if ((newMinDate.getTime() != minDate.getTime()) || (newMaxDate.getTime() != maxDate.getTime()))
												//if ((newMinDate.getTime() != valuesMin.getTime()) || (newMaxDate.getTime() != valuesMax.getTime()))
												{
													var orgFrom = lDef.items[0].value;
													var orgTo = lDef.items[1].value;

													if ((newMinDate.getTime() == minDate.getTime()) && (newMaxDate.getTime() == maxDate.getTime()))
													{
														delete f.items['flt_' + lDef.id];
														lDef.items[0].value = lDef.items[0].text = lDef.minValue;
														lDef.items[1].value = lDef.items[1].text = lDef.maxValue;
													}
													else
													{
														var v1 = newMinDate.getDate() + '.' + (newMinDate.getMonth() + 1) + '.' + newMinDate.getFullYear();
														var v2 = newMaxDate.getDate() + '.' + (newMaxDate.getMonth() + 1) + '.' + newMaxDate.getFullYear();
														var newValue = v1 + "|" + v2;
														f.items['flt_' + lDef.id] = [newValue];
														lDef.items[0].value = lDef.items[0].text = v1;
														lDef.items[1].value = lDef.items[1].text = v2;
													}

													if ((orgFrom != lDef.items[0].value) || (orgTo != lDef.items[1].value))
														reload(lDef);
												}
											}
										});
								})();
							}
							else
							{
								(function()
								{
									var lDef = def;
									var unit = ((lDef.unit) && (options.unitDisplayPos === 'item')) ? ' (' + lDef.unit + ')' : '';
									var min = parseFloat(lDef.minValue);
									var max = parseFloat(lDef.maxValue);
									var valuesMin = (hasItems) ? parseFloat(lDef.items[start].value) : min;
									var valuesMax = (hasItems) ? parseFloat(lDef.items[lDef.items.length - 1].value) : max;
									if (valuesMin > valuesMax)
									{
										var tmp = valuesMin;
										valuesMin = valuesMax;
										valuesMax = tmp;
									}
									if ((valuesMin < min) || (valuesMin > max))
										valuesMin = min;
									if ((valuesMax > max) || (valuesMax < min))
										valuesMax = max;
									$('#sldr_flt_' + lDef.id + '_info').html('<strong>' + valuesMin + unit + '</strong> - <strong>' + valuesMax + unit + '</strong>');

									lDef.minValueSlider = min;
									lDef.maxValueSlider = max;

									$('#sldr_flt_' + lDef.id).slider(
										{
											range: true,
											min: min,
											max: max,
											values: [valuesMin, valuesMax],
											//step: (lDef.step) ? lDef.step : ((max - min) / 10),
											change: function(event, ui)
											{
												$('#sldr_flt_' + lDef.id + '_info').html('<strong>' + ui.values[0] + unit + '</strong> - <strong>' + ui.values[1] + unit + '</strong>');
											},
											slide: function(event, ui)
											{
												$('#sldr_flt_' + lDef.id + '_info').html('<strong>' + ui.values[0] + unit + '</strong> - <strong>' + ui.values[1] + unit + '</strong>');
											},
											stop: function(event, ui)
											{
												var newMin = parseFloat(ui.values[0]);
												var newMax = parseFloat(ui.values[1]);

												if ((newMin == min) && (newMax == max))
												{
													delete f.items['flt_' + lDef.id];
												}
												else
												{
													var newValue = ui.values[0] + "|" + ui.values[1];
													f.items['flt_' + lDef.id] = [newValue];
												}

												reload(lDef);
											}
										});
								})();
							}
						}
						else
							if ((def.isDateTime) && ((!def.displayType) || (def.displayType.toLowerCase() == 'textboxes')))
							{
								var id = def.id;
								var idFrom = 'flt_cal_' + id + '_from';
								var idTo = 'flt_cal_' + id + '_to';
								f.createCalendar(def, idFrom, idTo);
							}
					}

				}

				if (f.focusedId)
					$('#' + f.focusedId).focus().select();

				if ((options.sequenceType > 0) && (QIPortalAPI.filters.module == 'QIHelpDesk'))
				{
					$('#' + controlId)[0].qiOptions = options;
				}

				if (QIPortalAPI.lastSetScroll)
					window.setTimeout(function () { window.scrollTo(0, QIPortalAPI.lastSetScroll); }, 500);
			}, 1);
		}
	};

	f.createCalendar = function(def, idFrom, idTo)
	{
		var calFrom = new JCalendar(null, null, idFrom);
		var calTo = new JCalendar(null, null, idTo);
		calFrom.attachToControl(idFrom, 3, { DayNames: ['po', 'út', 'st', 'čt', 'pá', 'so', 'ne'], MonthNames: ['Leden', 'Únor', 'Březen', 'Duben', 'Květen', 'Červen', 'Červenec', 'Srpen', 'Září', 'Říjen', 'Listopad', 'Prosinec'], Today: 'Dnes', Empty: 'Prázdné' });
		calTo.attachToControl(idTo, 3, { DayNames: ['po', 'út', 'st', 'čt', 'pá', 'so', 'ne'], MonthNames: ['Leden', 'Únor', 'Březen', 'Duben', 'Květen', 'Červen', 'Červenec', 'Srpen', 'Září', 'Říjen', 'Listopad', 'Prosinec'], Today: 'Dnes', Empty: 'Prázdné' });

		window.setTimeout(function() {
			var from = $('#' + idFrom);
			from.prop('orgValue', from.val());
			from.blur(function() {
				if (from.val() != from.prop('orgValue'))
				{
					from.prop('orgValue', from.val());
					f.checkFromTo(def.id, 0);
				}
			});
		}, 10);
	};

	f.setFilterInfo = function(controlId, options)
	{
		f.filterInfoControlId = controlId;
		f.filterInfoOptions = options;
		window.setTimeout(function() { setInfo(controlId, options); }, 100);
	};

	function setInfo(controlId, options)
	{
		if (!controlId)
			return;

		$('#' + controlId).html('');

		if (f.activeFilters.length > 0)
		{
			var code = [];

			if (options.htmlBefore)
			{
				//code.push(options.htmlBefore);
				code.push($('<div />').html(options.htmlBefore).text());
			}

			code.push('<div class="Normal FilterBody">');
			var canceltext = QIPortalAPI.getText('Text.Cancel');

			for (var i = 0; i < f.activeFilters.length; i++)
			{
				var defItem = f.activeFilters[i];
				code.push('<div class="FilterRow">');
				code.push('<span class="Title">' + defItem.caption + options.labelSep + '</span>');
				code.push('<span class="Content">');

				var content;

				if (defItem.selectionType == 2) // slider
				{
					var start = (defItem.items[0].value == '*') ? 1 : 0;
					content = defItem.items[start].value + ' - ' + defItem.items[defItem.items.length - 1].value;
					code.push('<a href="javascript:void(0);" class="RemoveFilter" title="' + canceltext + '" onclick="QIPortalAPI.filters.remove(\'' + defItem.id + '\');">' + content + '</a>');
				}
				else
				{
					var lastSelected = 0;
					for (var j = 0; j < defItem.items.length; j++)
					{
						if (defItem.items[j].selected)
							lastSelected = j;
					}

					for (var j = 0; j < defItem.items.length; j++)
					{
						var item = defItem.items[j];
						if (item.selected)
						{
							var isep = (j == lastSelected) ? '' : options.itemSep;
							code.push('<a href="javascript:void(0);" class="RemoveFilter" title="' + canceltext + '" onclick="QIPortalAPI.filters.remove(\'' + defItem.id + '\', \'' + item.value.htmlEncode() + '\');">' + item.text + '</a>' + isep);
						}
					}
				}

				code.push('</span>');
				code.push('</div>');
			}
			code.push('</div>');
			code.push('<a href="javascript:void(0);" class="Normal FilterCancel" title="' + canceltext + '" onclick="QIPortalAPI.filters.remove(\'*\');">' + canceltext + '</a>');
			code.push('<div class="Clear"></div>');


			if (options.htmlAfter)
			{
				//code.push(options.htmlAfter);
				code.push($('<div />').html(options.htmlAfter).text());
			}

			$('#' + controlId).html(code.join('\n'));
		}
	}

	;

	f.remove = function(defId, value)
	{
		if (defId == '*')
		{
			f.items = [];

			for (var i = 0; i < f.definitions.length; i++)
			{
				var def = f.definitions[i];
				var controls = $('[id*=_flt_' + def.id + ']');
				if (controls.length)
				{
					for (var j = 0; j < controls.length; j++)
					{
						var control = controls[j];
						if ((control.type == 'checkbox') || (control.type == 'radio'))
						{
							$(control).attr("checked", false);
						}
					}
				}

				if ((def.selectionType == 2) && (QIPortalAPI.filters.helpDeskTicketGrid))
				{
					def.items[0].value = def.items[0].text = def.minValue;
					def.items[1].value = def.items[1].text = def.maxValue;

					$('#sldr_flt_' + def.id).slider("values", [def.minValueSlider, def.maxValueSlider]);
				}

			}

			reload();
			return;
		}

		var def = findDef(defId);
		if (!def)
			return;

		var values = [];

		if (def.selectionType != 2)
		{
			for (var i = 0; i < def.items.length; i++)
			{
				var item = def.items[i];
				if (item.value != value)
				{
					if (item.selected)
						values.push(item.value);
				}
				else
				{
					var control = $('[id*=_flt_' + def.id + '_' + i + ']');
					if (control.length)
						$(control[0]).attr("checked", false);
				}
			}
		}
		else
		{
			if (QIPortalAPI.filters.helpDeskTicketGrid)
			{
				def.items[0].value = def.items[0].text = def.minValue;
				def.items[1].value = def.items[1].text = def.maxValue;

				$('#sldr_flt_' + def.id).slider("values", [def.minValueSlider, def.maxValueSlider]);
			}
		}

		if (values.length == 0)
			delete f.items['flt_' + defId];
		else
			f.items['flt_' + defId] = values;

		reload();
	};

	function findDef(id)
	{
		if (id.substr(0, 4) == 'flt_')
			id = id.substr(4);

		var def = null;
		for (var i = 0; i < f.definitions.length; i++)
		{
			if (f.definitions[i].id == id)
			{
				def = f.definitions[i];
				break;
			}
		}
		return def;
	}

	function canDisplay(def, options)
	{
		if ((def.type == 0) && (!((options.global) || (options.globalItem))))
			return false;

		if ((def.type == 1) && (!options.local))
			return false;

		if ((def.type == 2) && (!options.local))
			return false;

		return true;
	}

	function renderDefault(controlId, options)
	{
		var code = [];
		var multiSelect = [];
		var lastItem = f.definitions.length - 1;
		var vertical = options.vertical;
		if (vertical)
			code.push('<table class="Normal LocalFilters">');

		iterateDefs(controlId, options, function(idx, def, displayType) {
			if ((def.selectionType == 1) && (displayType == 'combobox'))
				multiSelect.push(def);

			if (!canDisplay(def, options))
				return;

			if (vertical)
				code.push('<tr><td>');

			if (!options.globalItem)
				code.push('<span class="Normal FilterLabel">' + def.caption + '</span>');

			if (vertical)
				code.push('</td><td>');
			else
				if (options.labelSep != '')
					code.push(options.labelSep);

			createItems(def, code, displayType, options);

			if (vertical)
				code.push('</td></tr>');
			else
				if ((i < lastItem) && (options.itemSep != ''))
					code.push(options.itemSep);

		});

		if (options.vertical)
		{
			code.push('</table>');
		}

		$('#' + controlId).html(code.join('\n'));

		if (multiSelect.length > 0)
		{
			window.setTimeout(function() {
				for (var i = 0; i < multiSelect.length; i++)
				{
					setMultiselect(multiSelect[i]);
				}

			}, 50);
		}
	}

	function createUnitInfo(unitName)
	{
		return ' <span class="UnitInfo">(' + unitName + ')</span>';
	}

	function renderSections(controlId, options)
	{
		var code = [];
		var multiSelect = [];
		var groupParams = true;
		var paramGroups = null;

		if (!options.params)
			groupParams = false;

		if (groupParams)
		{
			paramGroups = [];
			for (var i = 0; i < f.definitions.length; i++)
			{
				var def = f.definitions[i];
				if (def.type != 2)
					continue;

				var grp = def.group;
				if (!grp)
					grp = "Ostatní";

				var grpItems;
				var pGroup = paramGroups[grp];
				if (pGroup)
					grpItems = paramGroups[grp].items;

				if ((!pGroup) || (!grpItems))
				{
					grpItems = [];
					paramGroups[grp] = { items: grpItems, expanded: false };
					paramGroups.push(grp);
				}
				grpItems.push(def);

				for (var j = 0; j < def.items.length; j++)
				{
					var item = def.items[j];
					if (item.selected)
					{
						paramGroups[grp].expanded = true;
						break;
					}
				}

			}
		}

		iterateDefs(controlId, options, function(idx, def, displayType) {
			if ((def.selectionType == 1) && (displayType == 'combobox'))
				multiSelect.push(def);

			if (!canDisplay(def, options))
				return;

			if ((groupParams) && (def.type == 2))
				return;

			var collapsed = ' Collapsed';

			if (def.selectionType == 2)
			{
				if ((def.items) && (def.items.length > 0))
				{
					var start = (def.items[0].value == '*') ? 1 : 0;
					if ((def.minValue != def.items[start].value) || (def.maxValue != def.items[start + 1].value))
						collapsed = ' Expanded';
				}
			}
			else
			{
				for (var j = 0; j < def.items.length; j++)
				{
					var item = def.items[j];
					if (item.selected)
					{
						collapsed = ' Expanded';
						break;
					}
				}
			}

			var unit = ((def.unit) && (options.unitDisplayPos === 'name')) ? createUnitInfo(def.unit) : '';

			code.push('<div class="Normal FilterSection">');
			code.push('<h3 class="Normal FilterSectionHeader ' + collapsed + '">' + def.caption + unit + '</h3>');
			code.push('<div class="Normal FilterSectionItems ' + collapsed + '">');

			createItems(def, code, displayType, options);

			code.push('</div>');
			code.push('</div>');
		});


		if (groupParams)
		{
			for (var i = 0; i < paramGroups.length; i++)
			{

				var caption = paramGroups[i];
				var pGroup = paramGroups[caption];

				var collapsed = pGroup.expanded ? ' Expanded' : ' Collapsed';

				code.push('<div class="Normal FilterSection">');
				code.push('<h3 class="Normal FilterSectionHeader ' + collapsed + '">' + caption + '</h3>');
				code.push('<div class="Normal FilterSectionItems ' + collapsed + '">');

				code.push('<div class="Normal ParamGroup">');

				var items = pGroup.items;
				for (var j = 0; j < items.length; j++)
				{
					var def = items[j];
					var displayType = def.displayType.toLowerCase();
					if (displayType == '')
						displayType = 'combobox';

					var unit = ((def.unit) && (options.unitDisplayPos === 'name')) ? createUnitInfo(def.unit) : '';

					//code.push('<div style="height: 20px;"></div>');
					code.push('<div class="ParamGroupItem">');
					code.push('<h3>' + def.caption + unit + '</h3>');
					code.push('<div>');

					createItems(def, code, displayType, options);

					code.push('</div>');
					code.push('</div>');
				}

				code.push('</div>');
				code.push('</div>');
				code.push('<div class="Clear"></div>');
				code.push('</div>');
			}
		}

		$('#' + controlId).html(code.join('\n'));

		window.setTimeout(function() {
			if (multiSelect.length > 0)
			{
				for (var i = 0; i < multiSelect.length; i++)
				{
					setMultiselect(multiSelect[i]);
				}
			}

			$('div.FilterSection .FilterSectionHeader').click(function() {
				var item = $(this);
				var next = item.next();
				if (item.is('.Collapsed'))
				{
					item.removeClass('Collapsed').addClass('Expanded');
					next.removeClass('Collapsed').addClass('Expanded');
				}
				else
				{
					item.removeClass('Expanded').addClass('Collapsed');
					next.removeClass('Expanded').addClass('Collapsed');
				}
			}
			);

		}, 50);
	}

	f.getUserClass = function(elemName)
	{
		return '';
	}

	function renderTabs(controlId, options)
	{
		var code = [];
		var headers = [];
		var multiSelect = [];
		var vertical = options.vertical;
		var cls = (vertical) ? "tab-side-container" : "tab-container";
		var groupParams = true;
		var paramGroups = null;

		if (!options.params)
			groupParams = false;

		if (groupParams)
		{
			paramGroups = [];
			for (var i = 0; i < f.definitions.length; i++)
			{
				var def = f.definitions[i];
				if (def.type != 2)
					continue;

				var grp = def.group;
				if (!grp)
					grp = "Ostatní";
				var grpItems = paramGroups[grp];
				if (!grpItems)
				{
					grpItems = [];
					paramGroups[grp] = grpItems;
					paramGroups.push(grp);
				}
				grpItems.push(def);
			}
		}

		code.push('<div class="' + cls + '">');
		code.push('<ul' + ((vertical) ? '' : ' class="etabs' + f.getUserClass('ul') + '"') + '>');
		var headerIdx = code.push('#@headerDef@#');
		code.push('</ul>');
		code.push('<div class="panel-container">');

		iterateDefs(controlId, options, function(idx, def, displayType) {
			if ((def.selectionType == 1) && (displayType == 'combobox'))
				multiSelect.push(def);

			if (!canDisplay(def, options))
				return;

			if ((groupParams) && (def.type == 2))
				return;

			var unit = ((def.unit) && (options.unitDisplayPos === 'name')) ? createUnitInfo(def.unit) : '';
			headers.push('<li' + ((vertical) ? '' : ' class="tab' + f.getUserClass('li') + '"') + '><a href="#tabs' + idx + '">' + def.caption + unit + '</a></li>');

			code.push('<div id="tabs' + idx + f.getUserClass('div#tabs') + '">');

			createItems(def, code, displayType, options);

			code.push('<div class="Clear"></div>');
			code.push('</div>');
		});

		if (groupParams)
		{
			for (var i = 0; i < paramGroups.length; i++)
			{
				var caption = paramGroups[i];
				headers.push('<li' + ((vertical) ? '' : ' class="tab"') + '><a href="#param_tab' + i + '">' + caption + '</a></li>');
				code.push('<div id="param_tab' + i + '">');
				code.push('<div class="Normal ParamGroup">');

				var items = paramGroups[paramGroups[i]];
				for (var j = 0; j < items.length; j++)
				{
					var def = items[j];
					var displayType = def.displayType.toLowerCase();
					if (displayType == '')
						displayType = 'combobox';

					var unit = ((def.unit) && (options.unitDisplayPos === 'name')) ? createUnitInfo(def.unit) : '';

					//code.push('<div style="height: 20px;"></div>');
					code.push('<div class="ParamGroupItem">');
					code.push('<h3>' + def.caption + unit + '</h3>');
					code.push('<div>');

					createItems(def, code, displayType, options);

					code.push('</div>');
					code.push('</div>');
				}

				code.push('</div>');
				code.push('<div class="Clear"></div>');
				code.push('</div>');
			}
		}

		code.push('</div>');
		code.push('</div>');
		code.push('<div class="Clear"></div>');

		code[headerIdx - 1] = headers.join('\n');

		$('#' + controlId).html(code.join('\n'));

		window.setTimeout(function() {
			if (multiSelect.length > 0)
			{
				for (var i = 0; i < multiSelect.length; i++)
				{
					setMultiselect(multiSelect[i]);
				}
			}

			var tab = $('.' + cls);
			if (vertical)
				tab.easytabs({ animate: false, tabActiveClass: "selected-tab", panelActiveClass: "displayed", updateHash: false });
			else
				tab.easytabs({ animate: false, animationSpeed: 'fast', updateHash: false });

			if (f.activeTab)
			{
				tab.easytabs('select', '#' + f.activeTab);
			}

			tab.bind('easytabs:after', function (evnt, clicked, target, settings)
			{
				f.activeTab = target[0].id;
			});
        }, 100);
	}

	function iterateDefs(controlId, options, callback)
	{
		for (var i = 0; i < f.definitions.length; i++)
		{
			var def = f.definitions[i];
			if ((def.type == 0) && (options.globalItem))
			{
				if (def.controlId != controlId)
				{
					continue;
				}
			}
			else
				if ((def.type == 0) && ((!options.global) || (def.controlId)))
				{
					continue;
				}
				else
					if ((def.type == 1) && (!options.local))
					{
						continue;
					}
					else
						if ((def.type == 2) && (!options.params))
						{
							continue;
						}

			var displayType = def.displayType.toLowerCase();
			//if (displayType == '')
			//	displayType = 'combobox';

			callback(i, def, displayType);
		}
	}


	function createItems(def, code, displayType, options)
	{

		if (def.selectionType == 2)
		{
			if (f.items['flt_' + def.id])
				addActiveFilter(def);

			switch (displayType)
			{
			case '':
			case 'basic':
			case 'textboxes':
				{
					createRange(def, code, options);
					break;
				}
			case 'slider':
				{
					createRangeSlider(def, code, options);
					break;
				}
			}

			return;
		}

		switch (displayType)
		{
		case '':
		case 'combobox':
		case 'listbox':
			{
				createSelectItems(def, code, displayType, options);
				break;
			}
		case 'checkbox':
			{
				createCheckboxItems(def, code, options);
				break;
			}
		case 'radio', 'radiobutton':
			{
				createRadioButtonItems(def, code, options);
				break;
			}
		case 'link':
			{
				createLinkItems(def, code, options);
				break;
			}
		}
	}

	function createSelectItems(def, code, displayType, options)
	{
		var multiple = '';
		if (def.selectionType == 1)
		{
			multiple = ' multiple="multiple"';
		}
		else
			if (displayType == 'listbox')
			{
				multiple = ' size="6"';
			}

		def.itemsPrefix = 'sel_flt_' + ((options.globalItem) ? 'itm_' : '');
		var id = def.id;

		code.push('<select id="sel_flt_' + id + '" class="Normal FilterSelection"' + multiple + ' onchange="QIPortalAPI.filters.change(\'flt_' + def.id + '\', this);">');
		//code.push('<option value="*">Vše</option>');

		var items = def.items;
		var hasItems = (items) && (items.length > 0);

		for (var j = 0; j < items.length; j++)
		{
			var item = items[j];

			if ((def.selectionType == 1) && (item.value == '*'))
				continue;

			var disabled = '';
			var cnt = '';

			if ((hasItems) && (options.displayCount))
			{
				var count = 0;
				if (def.items.length > (j))
					count = def.items[j].count;
				if (count >= 0)
				{
					cnt = ' &nbsp;<span style="color:gray">(' + count + ')</span>';
					if ((parseInt(item.count) == 0) && (options.disableZeroCountItems))
					{
						disabled = ' disabled="disabled"';
					}
				}
			}

			var val = item.value.htmlEncode();

			code.push('<option value="' + val + '"' + ((item.selected) ? ' selected="selected"' : '') + disabled + '>' + getItemText(def, item) + cnt + '</option>');

			if (item.selected)
				addActiveFilter(def);
		}
		code.push('</select>');
		var unit = ((def.unit) && (options.unitDisplayPos === 'item')) ? createUnitInfo(def.unit) : '';
		if (unit !== '')
			code.push(unit);
	}

	function createCheckboxItems(def, code, options)
	{
		var items = def.items;
		var hasItems = (items) && (items.length > 0);

		var start = 0;
		var isGroupAttr = def.isGroupAttr;
		if (isGroupAttr)
			start = 1;

		def.itemsPrefix = 'chb_flt_' + ((options.globalItem) ? 'itm_' : '');
		var id = def.id;

		code.push('<div class="FilterCheckBoxes cls_flt_' + def.id + '">');
		for (var j = start; j < items.length; j++)
		{
			var item = items[j];
			if (item.value == '*')
				continue;
			var click = ' onclick="QIPortalAPI.filters.selectCheckBox(\'' + def.id + '\', ' + j + ')"';

			var checked = (item.selected) ? ' checked="checked"' : '';

			var disabled = (item.value == '*err*') ? ' disabled="disabled"' : '';
			var cssAdd = '';
			var cnt = '';

			var unit = ((def.unit) && (options.unitDisplayPos === 'item')) ? createUnitInfo(def.unit) : '';

			if ((hasItems) && (options.displayCount))
			{
				var count = 0;
				if (def.items.length > (j))
					count = def.items[j].count;
				if (count >= 0)
				{
					cnt = ' &nbsp;<span style="color:gray">(' + count + ')</span>';
					if ((parseInt(item.count) == 0) && (options.disableZeroCountItems))
					{
						disabled = ' disabled="disabled"';
						cssAdd = ' Disabled';
					}
				}
			}

			var text = getItemText(def, item);
			if (isGroupAttr)
			{
				var idx = 0;
				while (text.charAt(idx) == '.')
					idx++;
				if (idx > 0)
					text = text.substr(idx);
			}

			code.push('<div class="FilterCheckBox' + cssAdd + '"><input type="checkbox" value="' + item.value.htmlEncode() + '" id="' + def.itemsPrefix + id + '_' + j + '" ' + click + checked + disabled + '/><label for="' + def.itemsPrefix + id + '_' + j + '">' + text + unit + cnt + '</label></div>');

			if (item.selected)
				addActiveFilter(def);
		}
		code.push('<div class="Clear"></div>');
		code.push('</div>');

	}

	function createRadioButtonItems(def, code, options)
	{
		var items = def.items;
		var hasItems = (items) && (items.length > 0);
		var start = 0;
		var isGroupAttr = def.isGroupAttr;
		if (isGroupAttr)
			start = 1;

		def.itemsPrefix = 'rb_flt_' + ((options.globalItem) ? 'itm_' : '');
		var id = def.id;

		code.push('<div class="FilterRadioButtons cls_flt_' + def.id + '">');
		for (var j = start; j < items.length; j++)
		{
			var item = items[j];
			//if (item.value == '*')
			//	continue;
			var click = ' onclick="QIPortalAPI.filters.selectValue(\'' + def.id + '\', \'' + item.value.htmlEncode() + '\')"';

			var checked = (item.selected) ? ' checked="checked"' : '';

			var disabled = '';
			var cssAdd = '';
			var cnt = '';

			var unit = ((def.unit) && (options.unitDisplayPos === 'item')) ? createUnitInfo(def.unit) : '';

			if ((hasItems) && (options.displayCount))
			{
				var count = 0;
				if (def.items.length > j)
					count = def.items[j].count;
				if (count >= 0)
				{
					cnt = ' &nbsp;<span style="color:gray">(' + count + ')</span>';
					if ((parseInt(item.count) == 0) && (options.disableZeroCountItems))
					{
						disabled = ' disabled="disabled"';
						cssAdd = ' Disabled';
					}
				}
			}

			var text = getItemText(def, item);
			if (isGroupAttr)
			{
				var idx = 0;
				while (text.charAt(idx) == '.')
					idx++;
				if (idx > 0)
					text = text.substr(idx);
			}

			code.push('<div class="FilterRadioButton' + cssAdd + '"><input type="radio" value="' + item.value.htmlEncode() + '" id="rb_flt_' + id + '_' + j + '" name="rb_flt_' + id + '" ' + click + checked + disabled + '/><label for="rb_flt_' + id + '_' + j + '">' + text + unit + cnt + '</label></div>');

			if (item.selected)
				addActiveFilter(def); //{ id: def.id, value: item.value, text: text });
		}
		code.push('<div class="Clear"></div>');
		code.push('</div>');
	}

	function createLinkItems(def, code, options)
	{
		var items = def.items;
		var hasItems = (items) && (items.length > 0);
		var start = 0;
		var isGroupAttr = def.isGroupAttr;
		if (isGroupAttr)
			start = 1;

		code.push('<div class="FilterLinks cls_flt_' + def.id + '">');
		for (var j = start; j < items.length; j++)
		{
			var item = items[j];
			if (item.value == '*')
				continue;
			var click = ' onclick="QIPortalAPI.filters.selectValue(\'' + def.id + '\', \'' + item.value.htmlEncode() + '\')"';

			var cssAdd = (item.selected) ? ' Selected' : '';

			var disabled = '';
			var cnt = '';

			var unit = ((def.unit) && (options.unitDisplayPos === 'item')) ? createUnitInfo(def.unit) : '';
			
			if ((hasItems) && (options.displayCount))
			{
				var count = 0;
				if (def.items.length > j)
					count = def.items[j].count;
				if (count >= 0)
				{
					cnt = ' &nbsp;<span style="color:gray">(' + count + ')</span>';
					if ((parseInt(item.count) == 0) && (options.disableZeroCountItems))
					{
						disabled = ' disabled="disabled"';
						cssAdd += ' Disabled';
					}
				}
			}


			var text = getItemText(def, item);
			if (isGroupAttr)
			{
				var idx = 0;
				while (text.charAt(idx) == '.')
					idx++;
				if (idx > 0)
					text = text.substr(idx);
			}

			code.push('<div class="FilterLink' + cssAdd + '"><a href="javascript:void(0);" ' + click + disabled + '>' + text + unit + cnt + '</a></div>');

			if (item.selected)
				addActiveFilter(def); //{ id: def.id, value: item.value, text: text });
		}
		code.push('<div class="Clear"></div>');
		code.push('</div>');
	}

	function getItemText(def, item)
	{
		if ((!def.staticValues) || (def.staticValues.length == 0))
			return item.text;

		for (var i = 0; i < def.staticValues.length; i++)
		{
			var staticVal = def.staticValues[i];
			if (staticVal.value == item.value)
			{
				return staticVal.text;
			}
		}

		return item.text;
	}

	function isSelected(def, value)
	{
		for (var i = 0; i < def.items.length; i++)
		{
			var item = def.items[i];
			if ((item.value == value) && (item.selected))
				return true;
		}

		return false;
	}

	function createRange(def, code, options)
	{
		if ((!def.items) || (def.items.length == 0))
			return;

		var start = (def.items[0].value == '*') ? 1 : 0;
		var valuesMin = def.items[start].value;
		var valuesMax = (def.items.length > start + 1) ? def.items[start + 1].value : def.items[start].value;

		var onfocus = ' onfocus="QIPortalAPI.filters.focusedId = this.id;" onblur="QIPortalAPI.filters.focusedId = null;"';

		var id = def.id;
		if (def.isDateTime)
		{
			id = 'cal_' + id;
		}
		else
		{
			valuesMin = parseFloat(valuesMin);
			valuesMax = parseFloat(valuesMax);
			if (valuesMin > valuesMax)
			{
				var tmp = valuesMin;
				valuesMin = valuesMax;
				valuesMax = tmp;
			}
		}

		code.push('<div class="Normal Range">');
		code.push('<span id="flt_' + id + '_lbl" class="RangeFromLabel">' + QIPortalAPI.getText('Text.From') + '</span>');
		code.push('<span class="RangeFrom"><input id="flt_' + id + '_from" type="textbox" value="' + valuesMin + '" onchange="return QIPortalAPI.filters.checkFromTo(\'' + def.id + '\', 0);"' + onfocus + '></span>');
		code.push('<span id="flt_' + id + '_lbl" class="RangeToLabel">' + QIPortalAPI.getText('Text.To') + '</span>');
		code.push('<span class="RangeTo"><input id="flt_' + id + '_to" type="textbox" value="' + valuesMax + '" onchange="return QIPortalAPI.filters.checkFromTo(\'' + def.id + '\', 1);"' + onfocus + '></span>');
		code.push('</div>');
	}

	f.checkFromTo = function(defId, type)
	{
		var def = findDef(defId);
		var min, max, orgFrom, orgTo, fromVal, toVal;
		var start = (def.items[0].value == '*') ? 1 : 0;

		if (def.isDateTime)
		{
			min = def.minValue;
			max = def.maxValue;
			orgFrom = def.items[start].value;
			orgTo = def.items[start + 1].value;
			fromVal = $('#flt_cal_' + def.id + '_from').val();
			toVal = $('#flt_cal_' + def.id + '_to').val();
		}
		else
		{
			min = parseFloat(def.minValue);
			max = parseFloat(def.maxValue);
			orgFrom = parseFloat(def.items[start].value);
			orgTo = parseFloat(def.items[start + 1].value);
			fromVal = parseFloat($('#flt_' + def.id + '_from').val());
			toVal = parseFloat($('#flt_' + def.id + '_to').val());

			/*
			if ((fromVal > toVal) || (fromVal < min) || (fromVal > max) || (toVal < min) || (toVal > max))
			{
			QIPortalAPI.alert('invalid value');
			return false;
			}
			*/
			if (fromVal > toVal)
			{
				var tmpVal = toVal;
				toVal = fromVal;
				fromVal = tmpVal;
			}
		}

		//if ((type == 0) && (orgFrom != fromVal))
		if ((orgFrom != fromVal) || (orgTo != toVal) || (QIPortalAPI.filters.helpDeskTicketGrid))
		{
			window.setTimeout(function() {
				var newValue = fromVal + "|" + toVal;
				if ((fromVal == min) && (toVal == max))
				{
					delete f.items['flt_' + def.id];

					if (QIPortalAPI.filters.helpDeskTicketGrid)
					{
						def.items[0].value = def.items[0].text = def.minValue;
						def.items[1].value = def.items[1].text = def.maxValue;
					}
				}
				else
				{
					f.items['flt_' + def.id] = [newValue];

					if (QIPortalAPI.filters.helpDeskTicketGrid)
					{
						def.items[0].value = def.items[0].text = fromVal;
						def.items[1].value = def.items[1].text = toVal;
					}
				}

				if (f.focusedId)
					f.otherItems.push('focus=' + f.focusedId);
				else
					if (f.otherItems.length > 0)
					{
						for (var i = f.otherItems.length - 1; i >= 0; i--)
						{
							if (f.otherItems[i].substr(0, 6) == 'focus=')
								f.otherItems.splice(i, 1);
						}
					}

				reload();
			}, 10);
		}

		return true;
	};

	function createRangeSlider(def, code, options)
	{
		if ((!def.items) || (def.items.length == 0))
			return;

		code.push('<div class="Normal Slider">');
		code.push('<div id="sldr_flt_' + def.id + '_info" class="Normal SliderInfo"></div>');
		code.push('<div id="sldr_flt_' + def.id + '"></div>');
		code.push('</div>');
		code.push('<div class="Clear"></div>');
	}

	f.selectCheckBox = function(id, idx)
	{
		var def = findDef(id);
		if (def == null)
			return;

		var checked;
		var items = def.items;
		var length = items.length;
		if (def.selectionType == 0)
		{
			var chBox = $('#' + def.itemsPrefix + id + '_' + idx);
			checked = chBox.prop('checked');

			for (i = 0; i < length; i++)
			{
				var itemId = '#' + def.itemsPrefix + id + '_' + i;
				$(itemId).prop('checked', false);
			}

			chBox.prop('checked', checked);
		}

		var values = [];
		for (i = 0; i < length; i++)
		{
			var item = $('#' + def.itemsPrefix + id + '_' + i);
			if (item.prop('checked'))
				values.push(item.val());
		}

		if (values.length == 0)
			delete f.items['flt_' + def.id];
		else
		{
			f.items['flt_' + def.id] = values;
		}

		reload(def);
	};

	f.selectValue = function(id, value)
	{
		var def = findDef(id);
		if (def == null)
			return;

		var values = [];
		if (value != '*')
			values.push(value);

		if (values.length == 0)
			delete f.items['flt_' + def.id];
		else
		{
			f.items['flt_' + def.id] = values;
		}

		reload(def);
	};

	function setMultiselect(def)
	{
		var id = '#sel_flt_' + def.id;
		var ctrl = $(id);
		if (ctrl)
		{
			ctrl.removeAttr("onchange");
			ctrl.multiselect({
				header: false,
				noneSelectedText: QIPortalAPI.getText('Text.NoSelection'),
				selectedText: QIPortalAPI.getText('Text.Selected') + ': #',
				classes: 'Normal',
				minWidth: 'auto',
				click: function(event, ui)
				{
					var checked = ctrl.multiselect("getChecked");
					if (checked.length == 0)
						delete f.items['flt_' + def.id];
					else
					{
						var values = [];
						for (var i = 0; i < checked.length; i++)
							values.push(def.items[checked[i].value].value);
						f.items['flt_' + def.id] = values;
					}

					reload(def);
				}
			});
			$('.ui-multiselect-checkboxes li').addClass('Normal');
		}
	}

})();